function cb_m22
% Menu 22
% Calibrate crosstalk

  global persParamsDir
  global Hcal
  global Hcross  
  global f
  global sfontsize
  global hdt
   
  qtext{1}='Is the setup like this:';
  qtext{2}='* MA is connected properly!';
  qtext{3}='* MA switch is set to B!';
 
  btn = questdlg (qtext, 'Setup Check!','Yes', 'No','No');
  
  if strcmp (btn, 'Yes')
    
    cancelMeasurement; 
    Haux = measureH;
    
    if ~isempty(Haux) 
      
      Hcross = Haux./Hcal;      
      sn = strcat(persParamsDir,'Hcross.mat');
      save('-mat',sn , 'Hcross'); 
       
      L=20*log10(abs(Hcross));
      P=180/pi*angle(Hcross);  
   
      if ishandle(hdt) 
          delete(hdt) 
      end;
   
      fa=f(1);
      fb=f(end);
      
      subplot(2,1,1)
      
      semilogx(f,L)
      axis([fa fb -120 0])
      grid
      title('Hcross');
      xlabel('Frequency / Hz')
      ylabel('Gain / dB')  
      ha1=gca;     
      
      subplot(2,1,2)
      
      semilogx(f,P)
      axis([fa fb -180 180]);
      grid
      xlabel('Frequency / Hz')
      ylabel('Phase / degree')
      ha2=gca;      
      
      set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);  
      sn = strcat(persParamsDir,'Hcross.png');
      print('-dpng',sn,'-r300');
      
      set(ha1, 'fontsize',sfontsize);   
      set(ha2, 'fontsize',sfontsize);       
      
    end
    
  end 
  
end